/**
* \file: mlink_wl_if_apx.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* MLINK WL Adapter
*
* \component: mlink
*
* \author: Michael Methner ADITG/SW1 mmethner@de.adit-jv.com
*
* \copyright: (c) 2003 - 2013 ADIT Corporation
*
* \history
* 0.1 Michael Methner Initial version
*
***********************************************************************/

#ifndef MLINK_USE_EGL

/* PRQA: Lint Message 160, 505, 578: deactivation because DLT macros generate this lint findings*/
/*lint -e160 -e505 -e578*/

#include <mlink_wl_if.h>
#include <mlink_wl_internals.h>

#include <apx.h>
#include <string.h>
#include <stdlib.h>
#include <poll.h>

struct mlink_wl_if_context
{
  struct apx apx_ctx;
  struct apx_buffer * apx_buf;
};


int mlink_wl_if_set_surface_format(mlink_wl_context * p_wl_ctx,
    VNCPixelFormat * p_framebuffer_pixelformat)
{
  VNCPixelFormat rgb565 = VNCPixelFormatRGB(5, 6, 5, 0);
  VNCPixelFormat rgb888 = VNCPixelFormatRGB(8, 8, 8, 0);
  VNCPixelFormat rgb444 = VNCPixelFormatRGB(4, 4, 4, 0);

  if (mlink_wl_is_equal_vnc_pixelformat(&rgb565, p_framebuffer_pixelformat))
    {
      p_wl_ctx->surface_format = APX_PIXELFORMAT_RGB_565;
    }
  else if (mlink_wl_is_equal_vnc_pixelformat(&rgb888, p_framebuffer_pixelformat))
    {
      p_wl_ctx->surface_format = APX_PIXELFORMAT_RGBX_8888;
    }
  else if (mlink_wl_is_equal_vnc_pixelformat(&rgb444, p_framebuffer_pixelformat))
    {
      p_wl_ctx->surface_format = APX_PIXELFORMAT_RGBX_4444;
    }
  else
    {
      return MLINK_WL_IF_FAIL;
    }

  return MLINK_WL_IF_SUCCESS;
}


int
mlink_wl_if_init(mlink_wl_context * p_wl_ctx)
{
  if(p_wl_ctx)
    {
      p_wl_ctx->p_wl_if_context = malloc(sizeof(mlink_wl_if_context));

      if(p_wl_ctx->p_wl_if_context)
        {
          memset(p_wl_ctx->p_wl_if_context, 0, sizeof(mlink_wl_if_context));
          return MLINK_WL_IF_SUCCESS;
        }
      else
        {
          return MLINK_WL_IF_FAIL;
        }
    }

  return MLINK_WL_IF_FAIL;
}


void
mlink_wl_if_deinit(mlink_wl_context * p_wl_ctx)
{
    if(p_wl_ctx && p_wl_ctx->p_wl_if_context)
    {
        if (!p_wl_ctx->is_h264_enabled)
        {
            if(p_wl_ctx->p_wl_if_context->apx_buf)
            {
                apx_buffer_destroy(p_wl_ctx->p_wl_if_context->apx_buf, NULL/*sink->wl_display*/);
                p_wl_ctx->p_wl_if_context->apx_buf = NULL;
            }

            if(apx_deinit(&p_wl_ctx->p_wl_if_context->apx_ctx) < 0)
            {
                if (p_wl_ctx->p_dlt_ctx)
                {
                    DLT_LOG(*p_wl_ctx->p_dlt_ctx, DLT_LOG_ERROR,
                            DLT_STRING("mlink_wl: apx_deinit failed() failed"));
                }
            }
        }

        mlink_free_mem((void **)&p_wl_ctx->p_wl_if_context);
    }
}


void
mlink_wl_if_init_global_handler(void* data, struct wl_registry* registry,
    uint32_t name, const char* interface, uint32_t version)
{
  mlink_wl_context * p_wl_ctx = (mlink_wl_context *) data;

  if(p_wl_ctx)
  {
    if (apx_global_handler(&p_wl_ctx->p_wl_if_context->apx_ctx,
                              registry, name, interface, version) < 0)
      {
        if (p_wl_ctx->p_dlt_ctx)
          {
            DLT_LOG(*p_wl_ctx->p_dlt_ctx, DLT_LOG_INFO,
                DLT_STRING("mlink_wl: apx_global_handler failed"));
          }
      }

    if (apx_init(&p_wl_ctx->p_wl_if_context->apx_ctx) < 0)
      {
        if (p_wl_ctx->p_dlt_ctx)
          {
            DLT_LOG(*p_wl_ctx->p_dlt_ctx, DLT_LOG_ERROR,
                DLT_STRING("mlink_wl: apx_init() failed"));
          }
      }
  }
}




int
mlink_wl_if_create_img(mlink_wl_context * p_wl_ctx, int width, int height)
{
  unsigned int stride;
  if (p_wl_ctx && p_wl_ctx->p_wl_if_context)
    {
      p_wl_ctx->p_wl_if_context->apx_buf = apx_buffer_create(
          &p_wl_ctx->p_wl_if_context->apx_ctx, width, height,
          (apxPixelFormat)p_wl_ctx->surface_format);

      if(!p_wl_ctx->p_wl_if_context->apx_buf)
        {
          if (p_wl_ctx->p_dlt_ctx)
            {
              DLT_LOG(*p_wl_ctx->p_dlt_ctx, DLT_LOG_ERROR,
                  DLT_STRING("mlink_wl: apx_buffer_create() failed"));
            }
          return MLINK_WL_IF_FAIL;
        }

      p_wl_ctx->width = width;
      p_wl_ctx->height = height;

      if(apx_buffer_get_stride(p_wl_ctx->p_wl_if_context->apx_buf, &stride) < 0)
        {
          if (p_wl_ctx->p_dlt_ctx)
            {
              DLT_LOG(*p_wl_ctx->p_dlt_ctx, DLT_LOG_ERROR,
                  DLT_STRING("mlink_wl: apx_buffer_get_stride() failed"));
            }
          mlink_wl_if_destroy_img(p_wl_ctx);
          return MLINK_WL_IF_FAIL;
        }

      p_wl_ctx->stride = (int) stride;

      if(apx_buffer_map(p_wl_ctx->p_wl_if_context->apx_buf,
          (void **) &(p_wl_ctx->p_image[0])) < 0)
        {
          if (p_wl_ctx->p_dlt_ctx)
            {
              DLT_LOG(*p_wl_ctx->p_dlt_ctx, DLT_LOG_ERROR,
                  DLT_STRING("mlink_wl: apx_buffer_map() failed"));
            }
          mlink_wl_if_destroy_img(p_wl_ctx);
          return MLINK_WL_IF_FAIL;
        }

      return MLINK_WL_IF_SUCCESS;
    }
  else
    {
      return MLINK_WL_IF_FAIL;
    }
}


void
mlink_wl_if_destroy_img(mlink_wl_context * p_wl_ctx)
{
  if (p_wl_ctx && p_wl_ctx->p_wl_if_context)
    {
      if(p_wl_ctx->p_wl_if_context->apx_buf)
        {
          apx_buffer_destroy(p_wl_ctx->p_wl_if_context->apx_buf, NULL/*sink->wl_display*/);
          p_wl_ctx->p_wl_if_context->apx_buf = NULL;
        }
    }
}


void
mlink_wl_if_draw(mlink_wl_context * p_wl_ctx)
{
  if (p_wl_ctx && p_wl_ctx->p_wl_if_context)
    {
      if (apx_buffer_commit(&p_wl_ctx->p_wl_if_context->apx_ctx,
                            p_wl_ctx->p_wl_if_context->apx_buf, p_wl_ctx->p_wl_surface, 0, 0,
                            p_wl_ctx->width, p_wl_ctx->height, p_wl_ctx->p_wl_display) < 0)
        {
          if (p_wl_ctx->p_dlt_ctx)
            {
              DLT_LOG(*p_wl_ctx->p_dlt_ctx, DLT_LOG_ERROR,
                  DLT_STRING("mlink_wl: apx_buffer_commit() failed"));
            }
        }

      if(apx_buffer_map(p_wl_ctx->p_wl_if_context->apx_buf, (void **)&(p_wl_ctx->p_image)) < 0)
        {
        if (p_wl_ctx->p_dlt_ctx)
          {
            DLT_LOG(*p_wl_ctx->p_dlt_ctx, DLT_LOG_ERROR,
                DLT_STRING("mlink_wl: (draw) apx_buffer_map() failed"));
          }
        }
    }
}


/*lint +e160 +e505 +e578*/

#endif /* MLINK_USE_EGL */
